#ifndef WaveBump
	#define WaveBump 1.0
#endif
#ifndef WaveScale
	#define WaveScale 1
#endif
#ifndef Foam
	#define Foam 0
#endif

#define BaseOpacity 0.95
//#define InvertWaves

struct VS_INPUT_MAIN 
{
    float3 Position   : POSITION;
    float2 TexCoord   : TEXCOORD0;
	float3 WorldTxR3  : TEXCOORD1;
	float2 TexTx0R2   : TEXCOORD2;
};

struct VS_OUTPUT_MAIN
{
    float4 Position 	: POSITION;
    float2 TexCoord0	: TEXCOORD0;
    float4 TexCoord1	: TEXCOORD1;
	float4 WorldPosViewDepth : TEXCOORD2;
};

struct VS_INPUT_SHORE // 258
{
    float4 Position   : POSITION;
    float2 TexCoord   : TEXCOORD0;
};

struct VS_OUTPUT_SHORE
{
    float4 Position 	: POSITION;
    float2 TexCoord 	: TEXCOORD0;
	float FogAmount		: TEXCOORD1;
};

sampler2D Tex0 : register( s0 ); // Background
sampler2D Tex1 : register( s1 ); // Waves
sampler2D Tex7 : register( s7 ); // Waves

samplerCUBE TexEnv : register( s4 );
sampler2D TexNormal : register( s5 ); 
sampler2D TexNormalPrev : register( s6 );

float fBlendFactor;

float4x4 World : WORLD;
float4x4 View : VIEW;
float4x4 ViewProj : VIEWPROJ;

float4 TFactor : TFACTOR;
float4x4 TexTx0 : TEXTX0;
float4x4 TexTx1 : TEXTX1;

#define WorldSpaceLight
#include "Light.fx"
#include "Fog.fx"

VS_OUTPUT_MAIN vs_main(in VS_INPUT_MAIN In)
{
    VS_OUTPUT_MAIN Out;
	// World matrix is always identity + translation in the last row
	float4 posWorld = float4(In.Position + In.WorldTxR3, 1);
	// float4 posWorld = mul(In.Position, World);
    Out.Position = mul(posWorld, ViewProj); // position in clip space
	Out.WorldPosViewDepth = float4(posWorld.xyz, mul(posWorld, View).z); // position in world space & depth of position in view space
	
	float3 TC = float3(In.TexCoord, 1);//, 1);
	
	// Texture transform 2x2 + translation
    Out.TexCoord0 = mul(TC.xy, (float2x2)TexTx0).xy + In.TexTx0R2;
    // Out.TexCoord0 = mul(TC, (float3x3)TexTx0).xy;
	
	// TODO: this is just rescaling - need just one "TC*scalar" multiply
    Out.TexCoord1 = mul(TC, (float3x3)TexTx1).xyxy;
	
	// Make waves more prolonged
	Out.TexCoord1.x *= 0.5;
	Out.TexCoord1 /= 8;
	// Store adjusted coordinates
	Out.TexCoord1 *= float4(WaveScale, WaveScale, 7.5,5.7);//13.5, 19.7);
	return Out;
}

float4 ps_main(in VS_OUTPUT_MAIN In) : COLOR
{
	float4 Color = 0;
	
	// Main waves
	float3 N1c = tex2D(TexNormal, In.TexCoord1.xy).xyz;
	float3 N1p = tex2D(TexNormalPrev, In.TexCoord1.xy).xyz;
	float3 N1 = normalize(lerp(N1p, N1c, fBlendFactor) - 0.5).xzy;
	N1.y *= WaveBump;
	// Small ripples
	float3 N2 = normalize(tex2D(TexNormal, In.TexCoord1.zw).xyz - 0.5).xzy;
	N2.y *= WaveBump;
	
#ifdef InvertWaves
	N1.xz = -N1.xz;
	N2.xz = -N2.xz;
#endif

	float distanceFallof = 1 + dot(abs(ddx(In.TexCoord1.xy)) + abs(ddy(In.TexCoord1.xy)), 5);
	N1.xz *= 3 / distanceFallof;
	N2.xz *= 1 / distanceFallof;
	
	// View vector in world space
	float3 V = -normalize(In.WorldPosViewDepth.xyz);

	// Combine normals (world space)
	// + add bias to make more waves "face" toward the camera
	float3 N = normalize(N1+N2);
	
	N = normalize(N+V*pow(1-V.y,8)*0.01);
	
	float NdotV = dot(N,V);

	// Fresnel term
	float fr0 = 0.05; // base reflectivity
	float fr = saturate(fr0 + pow(1 - NdotV, 8) * (1 - fr0));

	Color.a = BaseOpacity + fr;
	
	// Diffuse + ambient 
	float NdotL = dot(normalize(N1), Sun.vWorldDir);
	float3 sunLight = saturate(NdotL * Sun.vDiffuse + vAmbientLight);
	Color.rgb += tex2D(Tex0, In.TexCoord0).rgb * TFactor.rgb * (1 - fr);
	Color.rgb += saturate(1 - fr) * (fr + 0.05) * 0.5 * vFogColor * sunLight;
	
	#if Foam == 1
		float4 ee1 = tex2D(Tex1, In.TexCoord1.xy);
		float4 ee2 = tex2D(Tex7, In.TexCoord1.xy);
		Color.rgb += saturate(pow(saturate(lerp(ee2.a,ee1.a,fBlendFactor)-0.55)*8,2.5)) * sunLight;
	#endif

	// Specular (using direct reflectiong instead of half vector)
	float3 R = reflect(-Sun.vWorldDir, N);
	float RdotV = saturate(dot(V, R));
	// Strong and weak
	float spec = pow(RdotV, 1000) * saturate(fr + 0.5) + pow(RdotV, 20) * 2 * fr;
	Color.rgb += spec * Sun.vSpecular;

	// Environment
	float3 cubeVec = reflect(-V, N);
	if(NdotV < 0) cubeVec.y = -V;
	cubeVec.y = saturate(cubeVec.y); // never reflect below horizon
	cubeVec = 1;
	Color.rgb += saturate((1 - spec) * (fr + 0.1)) * texCUBE(TexEnv, cubeVec).rgb * vAmbientLight;

	// Pixel fog (sea water consists of very large polygons)
	ApplyFog(Color, CalcFog(In.WorldPosViewDepth.a));
	
	return Color;
}

VS_OUTPUT_SHORE vs_shore(in VS_INPUT_SHORE In)
{
    VS_OUTPUT_SHORE Out;
	float4 posWorld = mul(In.Position, World);
    Out.Position = mul(posWorld, ViewProj); 
	Out.TexCoord = In.TexCoord;
	Out.FogAmount = CalcFog(mul(posWorld, View).z);
	return Out;
}

float4 ps_shore(in VS_OUTPUT_SHORE In) : COLOR
{
	float4 Color;
	Color = tex2D(Tex0, In.TexCoord) * TFactor;
	ApplyFog(Color, In.FogAmount);
	return Color;
}

technique Water
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main();
		PixelShader = compile ps_3_0 ps_main();
	}
}

technique Shore
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_shore();
		PixelShader = compile ps_3_0 ps_shore();
	}
}