#define FOG_TYPE_NONE            0 
#define FOG_TYPE_EXP             1 
#define FOG_TYPE_EXP2            2 
#define FOG_TYPE_LINEAR          3 

struct VS_INPUT
{
    float4 Position   : POSITION;
    float2 TexCoord   : TEXCOORD0;
    float3 Normal     : NORMAL;
};


struct VS_OUTPUT
{
    float4 Position   : POSITION;
    float2 TexCoord   : TEXCOORD0;
    float4 WorldPos   : TEXCOORD1;
	float3 Normal : TEXCOORD2;
	float Fog : TEXCOORD3;
	float3 V : TEXCOORD4;
};

// Global variables
 float4x4 ViewProj;
 float4x4 World;
 float4x4 View;
 float4x4 matWorldIT;
 float4x4 matViewIT;
 float4x4 matWorldViewIT;
 
 //int iTexGenType;
 //float4x4 TexTransform;


// FOG 
int iFogType; 
float fFogStart; 
float fFogEnd; 
float fFogDensity; 
bool bFogRange;

VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;
	
    float4 posWorld = mul(In.Position, World);
    Out.Position = mul(posWorld, ViewProj); 

    float3 wNormal = normalize(mul(In.Normal, (float3x3)matWorldIT)); // normal in world space

    float3 P = mul(posWorld, View).xyz; // position in view space
    //float3 N = normalize(mul(In.Normal, (float3x3)matWorldViewIT)); // normal in view space
    float3 V = -normalize(P);

	Out.Normal = wNormal;
    Out.WorldPos = posWorld;
    Out.TexCoord = In.TexCoord;
	//Out.P = P;
	//Out.N = N;
	Out.V = V;

	// Apply fog 
	float d = bFogRange ? length(P) : P.z; 
	Out.Fog = 1.f * (iFogType == FOG_TYPE_NONE) 
             + 1.f/exp(d * fFogDensity) * (iFogType == FOG_TYPE_EXP) 
             + 1.f/exp(pow(d * fFogDensity, 2)) * (iFogType == FOG_TYPE_EXP2) 
             + saturate((fFogEnd - d)/(fFogEnd - fFogStart)) * (iFogType == FOG_TYPE_LINEAR); 
		
		
    return Out;
}