struct VS_INPUT
{
    float4 Position   : POSITION;
    float2 TexCoord   : TEXCOORD0;
};

float4x4 WorldViewProj;
//float4x4 World;

sampler2D Tex0 : register( s0 );

float4 vs_Opaque( 
	in VS_INPUT In) 
	: POSITION
{
    //return mul( mul( In.Position, World ), ViewProj );
	return mul( In.Position, WorldViewProj );
}

float4 ps_Opaque() : COLOR
{
    return 1;
}

float4 vs_Alpha( 
	in VS_INPUT In,
	out float2 TexCoord : TEXCOORD0) 
	: POSITION
{
	TexCoord = In.TexCoord;
    //return mul( mul( In.Position, World ), ViewProj );
	return mul( In.Position, WorldViewProj );
}

float4 ps_Alpha(float2 TexCoord : TEXCOORD0) : COLOR
{
	clip( tex2D(Tex0, TexCoord).a - 0.75f );
	return 1;
}

technique ShadowMap
{
	pass Opaque
	{
		VertexShader = compile vs_3_0 vs_Opaque();
		PixelShader = compile ps_3_0 ps_Opaque();
	}
	pass Alpha
	{
		VertexShader = compile vs_3_0 vs_Alpha();
		PixelShader = compile ps_3_0 ps_Alpha();
	}
}